<!-- Styles for all browsers and IE 10+ -->
<!--[if !IE]>-->
<link rel="stylesheet" href="assets/css/screen.css?v=141">

<?php

  /**
   * Override theme appearance with config settings 
   */

  // Requires Color Transformation Class
  use Mexitek\PHPColors\Color;

  // Get the appearance settings
  $config_primary_color = filter_var( $config['primary_color'], FILTER_SANITIZE_STRING );
  $config_tint = filter_var( $config['tint'], FILTER_SANITIZE_STRING );
  $config_image = filter_var( $config['image'], FILTER_SANITIZE_STRING );
  $config_texture = filter_var( $config['texture'], FILTER_SANITIZE_STRING );
  // If domain image override is set, use it
  if( 
    isset($current_domain['image']) 
    && $current_domain['image'] !== false 
    && $current_domain['image'] !== ''
  ) {
    $config_image = $current_domain['image'];
  }
  
  // Prepare colour variations
  
  // Primary Color
  // ----------------------------------------------------------
  $primary_color_instance = new Color($config_primary_color);
  // Regular
  $primary_color_hex = $config_primary_color;
  // Light 1
  $primary_color_light_1_hex = '#' . $primary_color_instance->lighten(5);

  // Tint Color
  // ----------------------------------------------------------
  $tint_instance = new Color($config_tint);
  // Regular
  $tint_hex = $config_tint;
  $tint_rgb = hex2rgb( $tint_hex );
  // Dark 1
  $tint_dark_1_hex = '#' . $tint_instance->darken(4);
  // Dark 2
  $tint_dark_2_rgb = hex2rgb( $tint_instance->darken(17) );
  // Light 1
  $tint_light_1_hex = '#' . $tint_instance->lighten(3);

?>

<style>
  
  <?php if( $config_primary_color != '' ): ?>
    /* Button */
    .send-btn {
      background-color: <?php echo $primary_color_hex; ?>;
    }
    .send-btn:hover {
      background-color: <?php echo $primary_color_light_1_hex; ?>;
    }
    /* Price tag */
    .tag-outline path {
      fill: <?php echo $primary_color_hex; ?> !important;
    }
    .tag-right-outline path {
      fill: <?php echo $primary_color_hex; ?> !important;
    }
    /* Footer heading */
    .footer .title {
      color: <?php echo $primary_color_hex; ?>;
    }
  <?php endif; ?>
  
  /* Background image */
  body {
    background-image: url('assets/images/bg-<?php echo $config_image; ?>.jpg');
  }
  
  <?php if( $config_tint != '' ): ?>
    /* Background tint */
    body:after {
      background-color: rgba(<?php echo $tint_rgb; ?>, .63);
    }
    /* Price tag background */
    .tag-fill path {
      fill: <?php echo $tint_dark_1_hex; ?> !important;
    }
    .tag-right-fill path {
      fill: <?php echo $tint_dark_1_hex; ?> !important;
    }
    /* Footer background */
    .footer {
      background-color: rgba(<?php echo $tint_dark_2_rgb; ?>, .63 );
    }
    /* Footer link hover */
    .footer a:hover {
      background-color: <?php echo $tint_hex; ?>;
    }
    /* More Domains button */
    .more-domains-btn {
      background-color: rgba(<?php echo $tint_dark_2_rgb; ?>, .63 );
    }
    .more-domains-btn:hover, 
    .more-domains-btn:focus {
      background-color: <?php echo $tint_hex; ?>;
    }
    /* Domain Portfolio link */
    .domains a:hover {
      background-color: <?php echo $tint_hex; ?>;
    }
    /* Offer form heading */
    .offer-form .title {
      color: <?php echo $tint_hex; ?>;
    }
    /* Toggle Field */
    .switch-field input:checked + label {
      background-color: <?php echo $tint_hex; ?>;
    }
  <?php endif; ?>

  <?php if( $config_texture != '' ): ?>
    /* Background texture */
    body:after {
      background-image: url('assets/images/texture-<?php echo $config_texture; ?>.png');
    }
  <?php endif; ?>
  
  /* Narrow screen background styles */
  @media (max-width: 480px) {
    .header {
      background-image: url('assets/images/bg-<?php echo $config_image; ?>.jpg');
    }
    .header:after {
      <?php if( $config_tint != '' ): ?>
        background-color: rgba(<?php echo $tint_rgb; ?>, .63);
      <?php endif; ?>
      <?php if( $config_texture != '' ): ?>
        background-image: url('assets/images/texture-<?php echo $config_texture; ?>.png');
      <?php endif; ?>
    }
  }
</style>

<!--<![endif]-->
<!-- Basic styles for older browsers, IE 9 and below -->
<!--[if lte IE 9]>
<link rel="stylesheet" href="assets/css/old-ie.css">
<![endif]-->