<section class="main">
  <div class="main-inner">
    <form action="?" method="post" class="offer-form" id="offer-form">
    <h2 class="title">make your offer</h2>
    <p class="description">
      <?php if( isset($current_domain['description']) ) { echo $current_domain['description']; } ?>
    </p>
    <?php 
      $error_style = 'display: none;';
      if( isset($error) && $error != '' ) {
        $error_style = '';
      }
    ?>
    <div class="form-error animated shake" style="<?php echo $error_style; ?>">
      <span aria-hidden="true" class="icon li_pen"></span>
      <p>Please correct the following and resubmit, thanks!</p>
      <ul><?php if( isset($error) ) { echo $error; } ?></ul>
    </div>

    <?php 
      $success_style = 'display: none;';
      if( isset($success) && $success != '' ) {
        $success_style = '';
      }
    ?>
    <div class="form-success animated zoomInDown" style="<?php echo $success_style; ?>">
      <span aria-hidden="true" class="icon li_like"></span>
      <?php if( isset($success) ) { echo $success; } ?>
    </div>

    <?php if( $success_style != '' ) : ?>
      <div class="fields">
        <div class="field-section-wrapper">
          <!-- Domain Select Field -->
          <?php if( $config['enable_domain_select_field'] === true ) : ?>
            <div class="field-wrapper border">
              <select name="domain" class="select-field" required>
                <option value="">Select domain...</option>
                <?php 
                  // Determine the pre-selected domain name, if any
                  $selected_domain = '';
                  if( isset($field_data['domain']) ) {
                    $selected_domain = $field_data['domain'];
                  } elseif( 
                    isset( $current_domain['not_for_sale'] )
                    && $current_domain['not_for_sale'] === FALSE 
                  ) {
                    $selected_domain = $current_domain['name'];
                  }
                ?>
                <?php foreach( $domains as $domain => $value ) : ?>
                  <?php 
                    // Skip not-for-sale domains
                    if( isset($value['not_for_sale']) && $value['not_for_sale'] === true ) { continue; } 
                  ?>
                  <?php
                    // Use the nicename if available
                    $nicename = '';
                    if( isset($value['nicename']) ) {
                      $nicename = $value['nicename'];
                    } else {
                      $nicename = $domain; 
                    }
                  ?>
                  <option 
                    value="<?php echo $domain; ?>"
                    <?php if( $selected_domain === $domain ) : ?>
                      selected
                    <?php endif; ?>
                  ><?php echo $nicename; ?></option>
                <?php endforeach; ?>
              </select>
            </div>
          <?php endif; ?>
          <!-- Buy/Lease Toggle Field -->
          <?php 
            // Skip not-for-sale domains
            $purchase_type_style = '';
            if( 
                (
                  // Not for Sale enabled
                  isset($current_domain['not_for_sale']) 
                  && $current_domain['not_for_sale'] === true
                ) || (
                  // or Purchase type field set to false for domain
                  isset($current_domain['enable_purchase_type_field'])
                  && $current_domain['enable_purchase_type_field'] === false
                ) || (
                  // or Purchase Type field not set
                  !isset($config['enable_purchase_type_field'])
                ) || (
                  // or Purchase Type field set to false globally
                  // and not true per domain
                  ( 
                    isset($config['enable_purchase_type_field'])
                    && $config['enable_purchase_type_field'] === false 
                  )
                  && 
                  ( 
                    isset($current_domain['enable_purchase_type_field'])
                    && $current_domain['enable_purchase_type_field'] !== true 
                  )
                )
              ) {
              $purchase_type_style = 'display: none;';
            }
          ?>
          <div 
            class="field-wrapper border" 
            id="purchase_type_field_wrapper" 
            style="<?php echo $purchase_type_style; ?>"
          >
            <div class="switch-field">
              <input type="radio" id="buy_field" name="purchase_type" value="buy" checked/>
              <label for="buy_field">Buy</label>
              <input type="radio" id="lease_field" name="purchase_type" value="lease" />
              <label for="lease_field">Lease</label>
            </div>
          </div>
          <!-- Offer Field -->
          <div class="field-wrapper border">
            <label for="offer" class="offer-label">Offer</label>
            <input 
              type="text" 
              name="offer"
              id="offer" 
              placeholder="offer ($)*" 
              class="text-field"
              required
              minlength="2"
              value="<?php if( isset($field_data['offer']) ) { echo $field_data['offer']; } ?>"
            >
          </div>
          <!-- Name Field -->
          <div class="field-wrapper border">
            <label for="name" class="name-label">Full Name</label>
            <input 
              type="text" 
              name="name" 
              id="name" 
              placeholder="full name*" 
              class="text-field"
              required
              minlength="2"
              value="<?php if( isset($field_data['name']) ) { echo $field_data['name']; } ?>"
            >
          </div>
          <!-- Email Field -->
          <div class="field-wrapper border">
            <label for="email" class="email-label">Email</label>
            <input 
              type="text" 
              name="email" 
              id="email" 
              placeholder="email*" 
              class="email-field"
              required
              minlength="5"
              value="<?php if( isset($field_data['email']) ) { echo $field_data['email']; } ?>"
            >
          </div>
          <!-- Message Field -->
          <?php if( $config['enable_message_field'] === true ) : ?>
            <div class="field-wrapper border">
            <label for="email" class="message-label">Message</label>
            <textarea 
              name="message" 
              id="message" 
              placeholder="message" 
              class="textarea-field"
            ><?php if( isset($field_data['message']) ) { echo $field_data['message']; } ?></textarea>
          </div>
          <?php endif; ?>
        </div><!-- /field-section-wrapper -->
        <!-- Anti-spam Trap -->
        <div class="antispam">Leave this empty: <input type="text" name="url"></div>
        <!-- Recaptcha Field -->
        <?php if( $config['enable_recaptcha'] === true ) : ?>
          <div class="g-recaptcha" data-sitekey="<?php echo $config['recaptcha_public_key']; ?>"></div>
        <?php endif; ?>
        <!-- Submit Button -->
        <div class="field-wrapper send-btn-wrapper">
          <input type="submit" name="send" value="send" class="send-btn">
        </div>
      </div><!-- /fields -->
    <?php endif; ?>
    </form>
  </div><!-- /main-inner -->
</section><!-- /main -->