<!doctype html>
<html>
<head>

  <meta charset="utf-8">

  <!-- Page Title -->
  <title><?php echo getTitle( $current_domain['nicename'], $domains ); ?></title>

  <!-- Page Description -->
  <meta name="description" content="<?php echo $current_domain['description'] ?>">
  
  <!-- Set the viewport to the device's screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Icon -->
  <link rel="shortcut icon" href="assets/images/icons/favicon.ico" type="image/x-icon" />
  <link rel="apple-touch-icon" href="assets/images/icons/favicon.png">

  <!-- Scripts and styles -->
  <?php include_once 'styles-partial-view.php'; ?>
  <?php include_once 'scripts-partial-view.php'; ?>
  <script>
    // Global object
    var DB2 = { 
      enable_purchase_type_field: <?php var_export($config['enable_purchase_type_field']); ?>,
      current_domain: '<?php echo $current_domain['name']; ?>',
      buy_prefix: 'is for sale!',
      lease_prefix: 'is available for lease!',
      price_tag_caption: '<?php echo str_replace( "'", '"', $config['price_tag_caption'] ); ?>',
      lease_price_tag_caption: '<?php echo str_replace( "'", '"', $config['lease_price_tag_caption'] ); ?>',
    }; 
  </script>
  <?php if( isset($config['head_code']) && $config['head_code'] != '' ): ?>
    <?php echo $config['head_code']; ?>
  <?php endif; ?>
</head>
<body>
  
  <div class="main-wrap">

    <!-- Title and price -->
    <?php include_once 'header-partial-view.php'; ?>
    
    <!-- Offer form -->
    <?php include_once 'offer-form-partial-view.php'; ?>

  </div>
  
  <!-- My Contact Details -->
  <?php include_once 'footer-partial-view.php'; ?>

  <!-- My Domain Portfolio -->
  <?php include_once 'domain-portfolio-partial-view.php'; ?>

  <?php 
    if( isset($_GET['editor']) ) {
      // Editor template
      include_once 'editor-view.php';
    }
  ?>

</body>
</html>