<header class="header">
  <div class="header-inner">
    <h1 class="title"><span><?php echo $current_domain['nicename']; ?></span></h1>
    <?php 
      // Should the theme show the sale info ("is for sale" text and price tag)?
      // Yes, unless the domain is not for sale
      // Hiding the elements with "display: none" enables them to show up later
      // when switching to another domain using the domain select field
      $show_sale_info = true;
      if( 
        isset($current_domain['not_for_sale']) 
        && $current_domain['not_for_sale'] === true
      ) {
        $show_sale_info = false;
      }
    ?>
    <span class="subtitle" style="<?php if ( ! $show_sale_info ) { echo 'display: none'; } ?>">
      <?php if( $show_sale_info ) : ?>is for sale!<?php endif; ?>
    </span>
    <div 
      class="price-tag" 
      style="<?php 
        // Only show the price tag if the domain is for sale and has a price
        if ( 
          ! $show_sale_info 
          || ( ! isset( $current_domain['price'] ) )
          || ( $current_domain['price'] == '' )
        ) { 
          echo 'display: none'; 
        } 
      ?>"
    >

      <span class="price"><?php if( isset($current_domain['price']) ) { echo $current_domain['price']; } ?></span>
      <span class="caption">
        <?php 
          if( isset($config['price_tag_caption']) ) {
            echo $config['price_tag_caption'];
          } else {
            echo '<abbr title="estimated">est.</abbr> value';
          }
        ?>
      </span>
      
      <div class="tag-left">
        <svg class="tag-outline" preserveAspectRatio="xMinYMin slice" viewBox="0 0 246 65" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:1.41421;">
          <g id="tag-outline">
            <path d="M23.776,0l221.24,0l0,2.798l-221.24,0c-2.429,0 -4.645,1.229 -5.932,3.288l-13.992,22.386c-1.41,2.252 -1.407,5.165 0.003,7.418l13.991,22.386c1.285,2.056 3.501,3.285 5.93,3.285l221.24,0l0,2.798l-221.24,0c-3.397,0 -6.503,-1.721 -8.305,-4.603l-13.991,-22.386c-1.973,-3.153 -1.973,-7.228 0,-10.381l13.991,-22.386c1.802,-2.882 4.908,-4.603 8.305,-4.603Zm0,24.624c4.166,0 7.555,3.388 7.555,7.555c0,4.166 -3.389,7.555 -7.555,7.555c-4.167,0 -7.555,-3.389 -7.555,-7.555c0,-4.167 3.388,-7.555 7.555,-7.555Zm0,13.991c3.548,0 6.436,-2.888 6.436,-6.436c0,-3.548 -2.888,-6.436 -6.436,-6.436c-3.548,0 -6.436,2.888 -6.436,6.436c0,3.548 2.888,6.436 6.436,6.436Z" style="fill:#c05862;"/>
          </g>
        </svg>
        <svg class="tag-fill" preserveAspectRatio="xMinYMin slice" viewBox="0 0 246 65" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:1.41421;">
          <g id="tag-fill">
            <path d="M245.016,0.2l0,63.913l-221.205,0c-3.373,0 -6.458,-1.709 -8.247,-4.571l-13.894,-22.23c-1.959,-3.132 -1.959,-7.178 0,-10.31l13.894,-22.23c1.789,-2.863 4.874,-4.572 8.247,-4.572l221.205,0Zm-221.205,24.454c4.138,0 7.503,3.365 7.503,7.503c0,4.138 -3.365,7.503 -7.503,7.503c-4.137,0 -7.502,-3.365 -7.502,-7.503c0,-4.138 3.365,-7.503 7.502,-7.503Z" style="fill:#28273c;fill-opacity:0.631373;"/>
          </g>
        </svg>
      </div>   
      <svg preserveAspectRatio="none" class="tag-right-outline" width="100%" height="100%" viewBox="0 0 12 65" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:1.41421;">
        <g id="tag-right-outline">
          <path d="M0,0l1.222,0c5.401,0 9.794,4.393 9.794,9.794l0,44.771c0,5.401 -4.393,9.794 -9.794,9.794l-1.222,0l0,-2.798l1.222,0c3.856,0 6.996,-3.14 6.996,-6.996l0,-44.771c0,-3.856 -3.14,-6.996 -6.996,-6.996l-1.222,0l0,-2.798Z" style="fill:#c05862;"/>
        </g>
      </svg>
      <svg preserveAspectRatio="none" class="tag-right-fill" width="100%" height="100%" viewBox="0 0 12 65" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:1.41421;">
        <g id="tag-right-fill">
          <path d="M0,0.2l0.676,0c5.363,0 9.726,4.366 9.726,9.726l0,44.462c0,5.363 -4.363,9.725 -9.726,9.725l-0.676,0l0,-63.913Z" style="fill:#28273c;fill-opacity:0.631373;"/>
        </g>
      </svg>
    </div>
  </div>
</header>