<!-- Editor output -->
  <section class="auth-info">Logged in as <?php echo $config['editor_login_email']; ?></section>

  <section class="settings" id="settings">
    <ul class="tab-nav" id="tab-nav">
      <li><span aria-hidden="true" class="li_world"></span> &nbsp; Domains</li>
      <li><span aria-hidden="true" class="li_mail"></span> &nbsp; Contact Form</li>
      <li><span aria-hidden="true" class="li_tag"></span> &nbsp; Price Tag</li>
      <li><span aria-hidden="true" class="li_bubble"></span> &nbsp; Footer</li>
      <li><span aria-hidden="true" class="li_photo"></span> &nbsp; Appearance</li>
      <li><span aria-hidden="true" class="li_pen"></span> &nbsp; Code</li>
    </ul>
    <form action="?" method="post" id="editor-form">
      <ul class="tab-content" id="tab-content">
        <!-- Domains -->
        <li>
          <div class="fields">
            <div class="fields-column fields-column-long">
              <div class="field-wrapper">
                <div id="domain_portfolio">
                  <table class="domain-portfolio-table">   
                    <tbody>
                      <?php $d = 0; ?>
                      <?php foreach( $domains as $domain => $arr ): ?>
                        <?php 
                          $d++;
                          if( isset($arr['nicename']) ) {
                            $domain = $arr['nicename'];
                          }
                        ?>
                        <tr>
                          <td>
                            <header class="domain-header">
                              <input type="text" name="portfolio_domain[]" placeholder="Domain.com" class="text-field" value="<?php echo $domain; ?>">
                              <button title="Edit Details" class="editor-btn small-btn details-btn">
                                <span aria-hidden="true" class="li_settings"></span>
                              </button>
                              <button title="Delete Domain" class="editor-btn small-btn delete-btn">
                                <span aria-hidden="true" class="li_trash"></span>
                              </button>
                            </header>                          
                            <section class="domain-details">
                              <div class="fields">
                                <div class="fields-column">
                                  <div class="field-wrapper">
                                    <label>Price</label>
                                    <input 
                                      type="text" 
                                      name="portfolio_price[]" 
                                      class="text-field" 
                                      value="<?php echo $arr['price']; ?>"
                                      placeholder="Price"
                                    >
                                  </div>
                                </div><!-- fields-column -->
                                <div class="fields-column"> 
                                  <div class="field-wrapper">
                                    <label>Lease Price <span class="tip" title="Shows a lease price when the purchase type field is enabled and the offer form is toggled to 'lease'."></span></label>
                                    <input 
                                      type="text" 
                                      name="portfolio_lease_price[]" 
                                      class="text-field" 
                                      value="<?php echo $arr['lease_price']; ?>"
                                      placeholder="Lease Price"
                                    >
                                  </div> 
                                </div><!-- fields-column -->
                              </div><!-- fields -->
                              <div class="fields">
                                <div class="fields-column">
                                  <div class="field-wrapper">
                                    <label>Description</label>
                                    <input 
                                      type="text" 
                                      name="portfolio_description[]" 
                                      class="text-field" 
                                      value="<?php echo $arr['description']; ?>"
                                      placeholder="Description"
                                    >
                                  </div>
                                </div><!-- fields-column -->
                                <div class="fields-column">
                                  <div class="field-wrapper">
                                    <label>Image</label>
                                    <select name="portfolio_image[]" class="select-field">
                                      <option value="">[default]</option>
                                      <?php foreach( $backgrounds as $bg ) : ?>
                                        <option 
                                          value="<?php echo $bg; ?>"
                                          <?php if( isset($arr['image']) && $arr['image'] == $bg): ?>
                                            selected="selected"
                                          <?php endif; ?>
                                        >
                                          <?php echo $bg; ?>
                                        </option>
                                      <?php endforeach; ?>
                                    </select>
                                  </div>
                                </div><!-- fields-column -->
                              </div><!-- fields -->
                              <div class="fields">
                                <div class="fields-column">
                                  <label>
                                    Purchase Type Field <span class="tip" title="Shows a buy/lease toggle field in the offer form. The [default] option uses the global Purchase Type Field setting."></span>
                                  </label>
                                  <select name="portfolio_enable_purchase_type_field[]" class="select-field">
                                    <option value="" <?php if( isset($arr['enable_purchase_type_field']) && $arr['enable_purchase_type_field'] === ''): ?>
                                            selected="selected"
                                          <?php endif; ?>>[default]</option>
                                    <option value="true" <?php if( isset($arr['enable_purchase_type_field']) && $arr['enable_purchase_type_field'] === true): ?>
                                            selected="selected"
                                          <?php endif; ?>>ON</option>
                                    <option value="false" <?php if( isset($arr['enable_purchase_type_field']) && $arr['enable_purchase_type_field'] === false): ?>
                                            selected="selected"
                                          <?php endif; ?>>OFF</option>
                                  </select>
                                </div><!-- fields-column -->
                                <div class="fields-column">
                                  <input 
                                      type="checkbox" 
                                      name="portfolio_not_for_sale[]" 
                                      id="portfolio_not_for_sale_<?php echo $d; ?>"
                                      class="checkbox-field"
                                      <?php if( isset($arr['not_for_sale']) && $arr['not_for_sale'] === true ) :  ?>checked="checked"<?php endif; ?>
                                      value="1"
                                    >
                                    <label for="portfolio_not_for_sale_<?php echo $d; ?>">
                                      Not For Sale <span class="tip" title="Hides domain from navigation and domain select field. Also hides price and &quot;is for sale&quot; subtitle when domain is visited directly."></span>
                                    </label>
                                </div><!-- fields-column -->
                              </div><!-- fields -->
                            </section>
                          </td>
                        </tr>
                      <?php endforeach; ?>
                    </tbody>
                  </table>
                  <button class="editor-btn small-btn add-domain-btn">+ &nbsp; Add Domain</button>
                </div>
              </div>
            </div><!-- fields-column -->
            <div class="fields-column fields-column-short">
              <div class="field-wrapper">
                <input 
                  type="checkbox" 
                  name="enable_domain_portfolio"
                  id="enable_domain_portfolio" 
                  class="checkbox-field"
                  <?php if ($config['enable_domain_portfolio']): ?>
                    checked="checked"
                  <?php endif; ?>
                >
                <label for="enable_domain_portfolio">Domain Portfolio <span class="tip" title="Show the domain portfolio? Requires page refresh after save."></span></label>
              </div>
              <div class="field-wrapper">
                <label for="recipient_name">Reject Price Percentage <span class="tip" title="Reject offers below this percentage of the domain's price."></span></label>
                <input 
                  type="text" 
                  name="reject_price_percentage"
                  id="reject_price_percentage" 
                  class="text-field"
                  value="<?php echo $config['reject_price_percentage']; ?>"
                >
              </div>
              <div class="field-wrapper">
                <label for="recipient_name">Google Analytics Tracking ID <span class="tip" title="Each domain's hits are recorded in Google Analytics as events."></span></label>
                <input 
                  type="text" 
                  name="ga_tracking_id"
                  id="ga_tracking_id" 
                  class="text-field"
                  value="<?php echo $config['ga_tracking_id']; ?>"
                >
              </div>
            </div>
          </div><!-- fields-column -->
        </li>
        <!-- Contact Form -->
        <li>
          <div class="fields">
            <div class="fields-column">
              <div class="field-wrapper">
                <label for="recipient_name">Recipient Name</label>
                <input 
                  type="text" 
                  name="recipient_name"
                  id="recipient_name" 
                  class="text-field"
                  value="<?php echo $config['recipient_name']; ?>"
                >
              </div>
              <div class="field-wrapper">
                <label for="recipient_email">Recipient Email</label>
                <input 
                  type="email" 
                  name="recipient_email"
                  id="recipient_email" 
                  class="email-field"
                  value="<?php echo $config['recipient_email']; ?>"
                >
              </div>
              <p><strong>Note:</strong> to help make sure emails sent from the contact form don't arrive in your spam folder, edit the SMTP settings in the config.php file directly.</p>
            </div>
            <div class="fields-column">
              <div class="field-wrapper long">
                <input 
                  type="checkbox" 
                  name="enable_domain_select_field"
                  id="enable_domain_select_field" 
                  class="checkbox-field"
                  <?php if ($config['enable_domain_select_field']): ?>
                    checked="checked"
                  <?php endif; ?>
                >
                <label for="enable_domain_select_field">Domain Select Field <span class="tip" title="Show a domain select field in the offer form? Requires page refresh after save."></span></label>
              </div>
              <div class="field-wrapper long">
                <input 
                  type="checkbox" 
                  name="enable_purchase_type_field"
                  id="enable_purchase_type_field" 
                  class="checkbox-field"
                  <?php 
                    if (
                      isset($config['enable_purchase_type_field'])
                      && $config['enable_purchase_type_field'] === true
                    ): 
                  ?>
                    checked="checked"
                  <?php endif; ?>
                >
                <label for="enable_purchase_type_field">Purchase Type Field <span class="tip" title="Shows a buy/lease toggle field in the offer form. This applies at the global level, and can be overriden per domain."></span></label>
              </div>
              <div class="field-wrapper long">
                <input 
                  type="checkbox" 
                  name="enable_message_field"
                  id="enable_message_field" 
                  class="checkbox-field"
                  <?php if ($config['enable_message_field']): ?>
                    checked="checked"
                  <?php endif; ?>
                >
                <label for="enable_message_field">Message Field <span class="tip" title="Show a message field in the offer form? Requires page refresh after save."></span></label>
              </div>
              <div class="field-wrapper long">
                <input 
                  type="checkbox" 
                  name="enable_recaptcha"
                  id="enable_recaptcha" 
                  class="checkbox-field"
                  <?php if ($config['enable_recaptcha']): ?>
                    checked="checked"
                  <?php endif; ?>
                >
                <label for="enable_recaptcha">reCAPTCHA spam protection <span class="tip" title="Include reCAPTCHA field to prevent automated messages? Requires page refresh after save."></span></label>
              </div>
              <div class="field-wrapper">
                <label for="recaptcha_public_key">reCAPTCHA Public Key</label>
                <input 
                  type="text" 
                  name="recaptcha_public_key"
                  id="recaptcha_public_key" 
                  class="text-field"

                  value="<?php echo $config['recaptcha_public_key']; ?>"
                >
              </div>
              <div class="field-wrapper">
                <label for="recaptcha_private_key">reCAPTCHA Private Key</label>
                <input 
                  type="text" 
                  name="recaptcha_private_key"
                  id="recaptcha_private_key" 
                  class="text-field"

                  value="<?php echo $config['recaptcha_private_key']; ?>"
                >
              </div>
            </div><!-- /fields-column -->
          </div><!-- /fields -->
        </li>
        <!-- Price Tag -->
        <li>
          <div class="fields">
            <div class="fields-column">
              <div class="field-wrapper">
                <label for="price_tag_caption">Price Tag Caption</label>
                <input 
                  type="text" 
                  name="price_tag_caption"
                  id="price_tag_caption" 
                  class="text-field"
                  value="<?php echo htmlentities($config['price_tag_caption']); ?>"
                >
              </div>
              <div class="field-wrapper">
                <label for="lease_price_tag_caption">Lease Price Tag Caption</label>
                <input 
                  type="email" 
                  name="lease_price_tag_caption"
                  id="lease_price_tag_caption" 
                  class="email-field"
                  value="<?php echo htmlentities($config['lease_price_tag_caption']); ?>"
                >
              </div>
            </div><!-- /fields-column -->
          </div><!-- /fields -->
        </li>
        <!-- Footer -->
        <li>
          <div class="fields">
            <div class="fields-column">
              <div class="field-wrapper">
                <label for="email">Email</label>
                <input 
                  type="email" 
                  name="email"
                  id="email_address" 
                  class="email-field"
                  value="<?php 
                    if( $config['email'] == 'false' ) {
                      $config['email'] = '';
                    }
                    echo $config['email']; 
                  ?>"
                >
              </div>
              <div class="field-wrapper">
                <label for="phone">Phone</label>
                <input 
                  type="text" 
                  name="phone"
                  id="phone" 
                  class="text-field"
                  value="<?php echo $config['phone']; ?>"
                >
              </div>
              <div class="field-wrapper">
                <label for="twitter_handle">Twitter Handle</label>
                <input 
                  type="text" 
                  name="twitter_handle"
                  id="twitter_handle" 
                  class="text-field"
                  value="<?php echo $config['twitter_handle']; ?>"
                >
              </div>
            </div>
            <div class="fields-column">
              <div class="field-wrapper">
                <label for="copyright">Copyright</label>
                <input 
                  type="text" 
                  name="copyright"
                  id="copyright" 
                  class="text-field"
                  value="<?php if( isset($config['copyright']) ) { echo $config['copyright']; } ?>"
                >
              </div>
              <div class="field-wrapper">
                <label for="privacy_policy_link">Privacy Policy Link <span class="tip" title="Optional - add HTML here for a Privacy Policy link or other content. It will display after the copyright notice."></span></label>
                <textarea
                  name="privacy_policy_link"
                  id="privacy_policy_link" 
                  class="text-field"
                  rows="3"
                ><?php if( isset($config['privacy_policy_link']) ) { echo $config['privacy_policy_link']; } ?></textarea>
              </div>
            </div>
          </div>
        </li>
        <!-- Appearance -->
        <li>
          <div class="fields">
            <div class="field-wrapper long">
              <label for="primary_color">Primary Color</label>&nbsp;
              <input 
                type="text" 
                name="primary_color"
                id="primary_color" 
                class="text-field color-field"
                value="<?php echo $config['primary_color']; ?>"
              > &nbsp; 
              <label for="tint">Tint</label>&nbsp;
              <input 
                type="text" 
                name="tint"
                id="tint" 
                class="text-field color-field"
                value="<?php echo $config['tint']; ?>"
              > 
            </div>
            <div class="field-wrapper long">
              <label>Image</label>
              <br>
              <label>
                <input 
                  type="radio"
                  name="image"
                  value=""
                  class="radio-input"
                  <?php if( $config['image'] == ''): ?>
                    checked="checked"
                  <?php endif; ?>
                >
                <div class="thumb-wrapper scale">
                  <img src="http://placehold.it/100/333333/cccccc?text=None" alt="">
                </div>
              </label>
              <?php foreach( $backgrounds as $bg ) : ?>
                <label>
                  <input 
                    type="radio"
                    name="image"
                    value="<?php echo $bg; ?>"
                    class="radio-input"
                    <?php if( $config['image'] == $bg): ?>
                      checked="checked"
                    <?php endif; ?>   
                  >
                  <div class="thumb-wrapper scale">
                    <img src="assets/images/bg-<?php echo $bg; ?>.jpg" alt="">
                  </div>
                </label>
              <?php endforeach; ?>
            </div>
            <div class="field-wrapper long">
              <label>Texture</label>
              <br>
              <label>
                <input 
                  type="radio"
                  name="texture"
                  value=""
                  class="radio-input"
                  <?php if( $config['texture'] == ''): ?>
                    checked="checked"
                  <?php endif; ?>
                >
                <div class="thumb-wrapper scale">
                  <img src="http://placehold.it/100/333333/cccccc?text=None" alt="">
                </div>
              </label>
              <?php foreach( $textures as $tex ) : ?>
                <label>
                  <input 
                    type="radio"
                    name="texture"
                    value="<?php echo $tex; ?>"
                    class="radio-input"
                    <?php if( $config['texture'] == $tex): ?>
                      checked="checked"
                    <?php endif; ?>                                        
                  >
                  <div class="thumb-wrapper">
                    <img src="assets/images/texture-<?php echo $tex; ?>.png" alt="">
                  </div>
                </label>
              <?php endforeach; ?>
            </div>
          </div><!-- /fields -->
        </li>
        <!-- Code -->
        <li>
          <div class="fields">
            <div class="field-wrapper long">
              <label for="head_code">&lt;head&gt; HTML<span class="tip" title="This code will be inserted in the page's <head> section. You can include <script> and <style> tags, for example."></span></label>
              <textarea
                name="head_code"
                id="head_code" 
                class="text-field"
                rows="7"
              ><?php if( isset($config['head_code']) ) { echo $config['head_code']; } ?></textarea>
            </div>
          </div>
        </li>
      </ul>
    </form>
    <div class="settings-btn-wrap">
      <button id="settings-btn" class="editor-btn settings-btn">
        <span aria-hidden="true" class="li_settings"></span> &nbsp; settings
      </button>
      <button id="save-btn" class="editor-btn save-btn">
        <span class="regular">save</span>
        <span style="display:none" class="saving">saving &nbsp; &nbsp; &nbsp; </span>
        <span class="error"><ul></ul></span>
      </button>
    </div>
  </section>
  <!-- Templates -->
  <!-- Domain Row Template -->
  <script type="text/template" id="domainPortfolioRowTemplate">
    <tr>
      <td>
        <header class="domain-header">
          <input type="text" name="portfolio_domain[]" placeholder="Domain.com" class="text-field">
          <button title="Edit Details" class="editor-btn small-btn details-btn">
            <span aria-hidden="true" class="li_settings"></span>
          </button>
          <button title="Delete Domain" class="editor-btn small-btn delete-btn">
            <span aria-hidden="true" class="li_trash"></span>
          </button>
        </header>                          
        <section class="domain-details">
          <div class="fields">
            <div class="fields-column">
              <div class="field-wrapper">
                <label>Price</label>
                <input 
                  type="text" 
                  name="portfolio_price[]" 
                  class="text-field" 
                  placeholder="Price"
                >
              </div>
            </div><!-- fields-column -->
            <div class="fields-column"> 
              <div class="field-wrapper">
                <label>Lease Price <span class="tip" title="Shows a lease price when the purchase type field is enabled and the offer form is toggled to &quot;lease&quot;."></span></label>
                <input 
                  type="text" 
                  name="portfolio_lease_price[]" 
                  class="text-field" 
                  placeholder="Lease Price"
                >
              </div> 
            </div><!-- fields-column -->
          </div><!-- fields -->
          <div class="fields">
            <div class="fields-column"> 
              <div class="field-wrapper">
                <label>Description</label>
                <input 
                  type="text" 
                  name="portfolio_description[]" 
                  class="text-field"
                  placeholder="Description"
                >
              </div> 
            </div><!-- fields-column -->
            <div class="fields-column">
                <div class="field-wrapper">
                  <label>Image</label>
                  <select name="portfolio_image[]" class="select-field">
                    <option value="">[default]</option>
                    <?php foreach( $backgrounds as $bg ) : ?>
                      <option 
                        value="<?php echo $bg; ?>"
                        <?php if( isset($arr['image']) && $arr['image'] == $bg): ?>
                          selected="selected"
                        <?php endif; ?>
                      >
                        <?php echo $bg; ?>
                      </option>
                    <?php endforeach; ?>
                  </select>
                </div>
              </div><!-- fields-column -->
          </div><!-- fields -->
          <div class="fields">
            <div class="fields-column">
              <label>
                Purchase Type Field <span class="tip" title="Shows a buy/lease toggle field in the offer form. The [default] option uses the global Purchase Type Field setting."></span>
              </label>
              <select name="portfolio_enable_purchase_type_field[]" class="select-field">
                <option value="" selected="selected">[default]</option>
                <option value="true">ON</option>
                <option value="false">OFF</option>
              </select>
            </div><!-- fields-column -->
            <div class="fields-column">
              <div class="field-wrapper">
                <input 
                  type="checkbox" 
                  name="portfolio_not_for_sale[]" 
                  id="portfolio_not_for_sale_<%=id%>"
                  class="checkbox-field"
                  value="1"
                >
                <label for="portfolio_not_for_sale_<%=id%>">
                  Not For Sale <span class="tip" title="Hides domain from navigation and domain select field. Also hides price and &quot;is for sale&quot; subtitle when domain is visited directly."></span>
                </label>
              </div>
            </div><!-- fields-column -->
          </div><!-- fields -->
        </section>
      </td>
    </tr>
  </script>
  <!-- Style Template -->
  <script type="text/template" id="styleTemplate">
    <style class="live-update-style">
      /* Styles based on primary color */
      /* Button */
      .send-btn {
        background-color: <%=primary_color_hex%>;
      }
      .send-btn:hover {
        background-color: <%=primary_color_light_1_hex%>;
      }
      /* Price tag */
      .tag-outline path {
        fill: <%=primary_color_hex%> !important;
      }
      .tag-right-outline path {
        fill: <%=primary_color_hex%> !important;
      }
      /* Footer heading */
      .footer .title {
        color: <%=primary_color_hex%>;
      }

      /* Styles based on tint color */
      /* Background tint */
      body:after {
        background-color: rgba(<%=tint_rgb%>, .63);
      }
      /* Price tag background */
      .tag-fill path {
        fill: <%=tint_dark_1_hex%> !important;
      }
      .tag-right-fill path {
        fill: <%=tint_dark_1_hex%> !important;
      }
      /* Footer background */
      .footer {
        background-color: rgba(<%=tint_dark_2_rgb%>, .63 );
      }
      /* Footer link hover */
      .footer a:hover {
        background-color: <%=tint_hex%>;
      }
      /* More Domains button */
      .more-domains-btn {
        background-color: rgba(<%=tint_dark_2_rgb%>, .63 );
      }
      .more-domains-btn:hover, 
      .more-domains-btn:focus {
        background-color: <%=tint_hex%>;
      }
      /* Domain Portfolio link */
      .domains a:hover {
        background-color: <%=tint_hex%>;
      }
      /* Offer form heading */
      .offer-form .title {
        color: <%=tint_hex%>;
      }
      /* Toggle Field */
      .switch-field input:checked + label {
        background-color: <%=tint_hex%>;
      }
    </style>
  </script>
  <!-- End Templates -->
  <script src="assets/js/vendor/jqColorPicker.min.js"></script>
  <script src="assets/js/editor-utils.js"></script>
  <script src="assets/js/editor.js"></script>
<!-- end Editor output -->