<?php
/*!
* Hybridauth
* https://hybridauth.github.io | https://github.com/hybridauth/hybridauth
* https://hybridauth.github.io/license.html
*/

namespace Hybridauth\Provider;

use Hybridauth\Adapter\OAuth2;
use Hybridauth\Exception\UnexpectedValueException;
use Hybridauth\Data;
use Hybridauth\User;

/**
 * Envato OAuth2 provider adapter.
 */
class Envato extends OAuth2
{

    /**
    * {@inheritdoc}
    */
    protected $apiBaseUrl = 'https://api.envato.com/';

    /**
    * {@inheritdoc}
    */
    protected $authorizeUrl = 'https://api.envato.com/authorization';

    /**
    * {@inheritdoc}
    */
    protected $accessTokenUrl = 'https://api.envato.com/token';

    /**
    * {@inheritdoc}
    */
    protected $apiDocumentation = 'https://build.envato.com/api/#oauth';

    /**
     * {@inheritdoc}
     */
    protected function initialize()
    {
        parent::initialize();

        $this->tokenRefreshParameters = [
            'grant_type' => 'refresh_token',
            'refresh_token' => $this->getStoredData('refresh_token'),
            'client_id' => $this->clientId,
            'client_secret' => $this->clientSecret
        ];
    }

    /**
    * {@inheritdoc}
    */
    public function getUserProfile()
    {
        $response = $this->apiRequest('v1/market/private/user/email.json');

        $data = new Data\Collection($response);

        if (! $data->exists('email')) {
            throw new UnexpectedApiResponseException('Provider API returned an unexpected response.');
        }

        $userProfile = new User\Profile();
        $userProfile->email = $data->get('email');
        return $userProfile;
    }

}