<?php

/**
 * Get Domain Info
 * Retrieves a domain's information
 *
 * @package Domain Broker 2
 * @author Derek Loewen <derek@loewenweb.com>
 */

// Exit if the ajax flag is not set
if ( ! isset($_GET['ajax']) ) {
    die('Error: AJAX flag not present.');
}

// Require config that contains domains array
require '../config.php';

// If a domain isn't specified, exit with error message
if( ! isset($_GET['domain_name']) ) {
    die( json_encode(['error' => 'Please specify a domain.']) );
} 

// If domain information isn't found, exit with error message
if( ! isset( $domains[$_GET['domain_name']] ) ) {
   die( json_encode(['error' => 'Domain information not available.']) );  
}

// Output the corresponding domain information
die( json_encode($domains[$_GET['domain_name']]) );

   