<?php
/* WARNING: DO NOT EDIT THIS FILE DIRECTLY. USE THE WEB-BASED EDITOR FEATURE OR EDIT CONFIG.PHP DIRECTLY */

/**
 * Configuration options
 * 
 * If you want to set up the most common options 
 * for Domain Broker 2 you're in the right place!
 *
 * Simply edit the contents (between quotation marks) 
 * of the items below to what you'd like.
 *
 * @package Domain Broker 2
 * @author Derek Loewen <derek@loewenweb.com>
 */

$config = array(
  // -------------------------------------------------------------------
  // General
  // -------------------------------------------------------------------
  // Show the domain portfolio?
  'enable_domain_portfolio' => *ENABLE_DOMAIN_PORTFOLIO_VALUE*,
  // In the offer form, enable the domain select field?
  'enable_domain_select_field' => *ENABLE_DOMAIN_SELECT_FIELD_VALUE*,
  // Enable the purchase type field for all domains by default?
  'enable_purchase_type_field' => *ENABLE_PURCHASE_TYPE_FIELD_VALUE*,
  // Reject offers below this percent of the domain's price
  'reject_price_percentage' => *REJECT_PRICE_PERCENTAGE_VALUE*,
  // Enable the "message" form field?
  'enable_message_field' => *ENABLE_MESSAGE_FIELD_VALUE*,
  // Google Analytics Tracking ID
  'ga_tracking_id' => '*GA_TRACKING_ID_VALUE*',
  // Script or style tags to insert in the template's <head> area
  'head_code' => '*HEAD_CODE_VALUE*',  
  // -------------------------------------------------------------------
  // Price Tag
  // -------------------------------------------------------------------
  'price_tag_caption' => '*PRICE_TAG_CAPTION_VALUE*',
  'lease_price_tag_caption' => '*LEASE_PRICE_TAG_CAPTION_VALUE*',
  // -------------------------------------------------------------------
  // Footer
  // -------------------------------------------------------------------
  'email' => '*EMAIL_VALUE*',
  'phone' => '*PHONE_VALUE*',
  // Twitter handle - just your username, no "@" symbol before it
  'twitter_handle' => '*TWITTER_HANDLE_VALUE*',
  // Copyright notice
  'copyright' => '*COPYRIGHT_VALUE*',
  // Privacy policy link HTML
  'privacy_policy_link' => '*PRIVACY_POLICY_LINK_VALUE*',
  // -------------------------------------------------------------------
  // Email/SMTP settings
  // -------------------------------------------------------------------
  'recipient_name' => '*RECIPIENT_NAME_VALUE*',
  'recipient_email' => '*RECIPIENT_EMAIL_VALUE*',
  'recipient_email_password' => '*RECIPIENT_EMAIL_PASSWORD_VALUE*',
  'smtp_server' => '*SMTP_SERVER_VALUE*',
  // -------------------------------------------------------------------
  // reCAPTCHA spam protection
  // -------------------------------------------------------------------
  'enable_recaptcha' => *ENABLE_RECAPTCHA_VALUE*,
  // Obtain keys from https://www.google.com/recaptcha
  'recaptcha_public_key' => '*RECAPTCHA_PUBLIC_KEY_VALUE*',
  'recaptcha_private_key' => '*RECAPTCHA_PRIVATE_KEY_VALUE*',
  // -------------------------------------------------------------------
  // Appearance options
  // -------------------------------------------------------------------
  // Background image options include:
  // beach, city-lights, mountains, network, tabletop, and wood
  'image' => '*IMAGE_VALUE*',
  // Tint colour used on top of the background image/back of price tag
  // Use hexadecimal format: #FFFFFF would add a white tint. 
  // Try out http://www.colorpicker.com/
  'tint' => '*TINT_VALUE*',
  // Primary colour used on buttons and on price tag outline
  'primary_color' => '*PRIMARY_COLOR_VALUE*',
  // Texture options include circles, diamonds, feathers, and rough
  'texture' => '*TEXTURE_VALUE*',
  // -------------------------------------------------------------------
  // Editor settings
  // -------------------------------------------------------------------
  'editor_login_email' => '*EDITOR_LOGIN_EMAIL_VALUE*',
  'envato_oauth_keys' => array(
      'client_id' => '*CLIENT_ID_VALUE*',
      'client_secret' => '*CLIENT_SECRET_VALUE*'
  )
);

// -------------------------------------------------------------------
// Domains
// -------------------------------------------------------------------
// A list of the domains you want to use with domain broker.
// This list is also used for the domain portfolio feature if
// the 'enable_domain_portfolio' setting is set to true
//
// Format (repeat for each domain): 
//
// 'domain name here' => array(
//     'nicename' => 'ReplacesDomainNameText' // optional
//     'enable_purchase_type_field' => true, // optional
//     'price' => 'price here',
//     'lease_price' => 'price here', // optional
//     'description' => 'description here',
//     'not_for_sale' => false,
//     'image' => '' // background override
// ),
//
// Notes:
// * If you don't want a price or description, erase the contents
//   inside the quote marks
// * If the price is blank, the tag will not show
// * Enter domain names *without* the "http://" in front
$domains = array(
  *DOMAINS_VALUE*
);