<?php

/**
 * Configuration options
 * 
 * If you want to set up the most common options 
 * for Domain Broker 2 you're in the right place!
 *
 * Simply edit the contents (between quotation marks) 
 * of the items below to what you'd like.
 *
 * @package Domain Broker 2
 * @author Derek Loewen <derek@loewenweb.com>
 */

$config = array(
  // -------------------------------------------------------------------
  // General
  // -------------------------------------------------------------------
  // Show the domain portfolio?
  'enable_domain_portfolio' => true,
  // In the offer form, enable the domain select field?
  'enable_domain_select_field' => false,
  // Enable the purchase type field for all domains by default?
  'enable_purchase_type_field' => false,
  // Reject offers below this percent of the domain's price
  'reject_price_percentage' => 0,
  // Enable the "message" form field?
  'enable_message_field' => false,
  // Google Analytics Tracking ID
  'ga_tracking_id' => '',
  // Script or style tags to insert in the template's <head> area
  'head_code' => '',  
  // -------------------------------------------------------------------
  // Price Tag
  // -------------------------------------------------------------------
  'price_tag_caption' => '<abbr title="estimated">est.</abbr> value',
  'lease_price_tag_caption' => 'monthly',
  // -------------------------------------------------------------------
  // Footer
  // -------------------------------------------------------------------
  'email' => '',
  'phone' => '',
  // Twitter handle - just your username, no "@" symbol before it
  'twitter_handle' => '',
  // Copyright notice
  'copyright' => '©2022. All Rights Reserved.',
  // Privacy policy link HTML
  'privacy_policy_link' => '',
  // -------------------------------------------------------------------
  // Email/SMTP settings
  // -------------------------------------------------------------------
  'recipient_name' => 'OFFRE DOMAINE',
  'recipient_email' => 'ahmed@khelil.be',
  'recipient_email_password' => '',
  'smtp_server' => '',
  // -------------------------------------------------------------------
  // reCAPTCHA spam protection
  // -------------------------------------------------------------------
  'enable_recaptcha' => false,
  // Obtain keys from https://www.google.com/recaptcha
  'recaptcha_public_key' => '',
  'recaptcha_private_key' => '',
  // -------------------------------------------------------------------
  // Appearance options
  // -------------------------------------------------------------------
  // Background image options include:
  // beach, city-lights, mountains, network, tabletop, and wood
  'image' => 'city-lights',
  // Tint colour used on top of the background image/back of price tag
  // Use hexadecimal format: #FFFFFF would add a white tint. 
  // Try out http://www.colorpicker.com/
  'tint' => '#322F48',
  // Primary colour used on buttons and on price tag outline
  'primary_color' => '#C05862',
  // Texture options include circles, diamonds, feathers, and rough
  'texture' => '',
  // -------------------------------------------------------------------
  // Editor settings
  // -------------------------------------------------------------------
  'editor_login_email' => 'sabrejunior@gmail.com',
  'envato_oauth_keys' => array(
      'client_id' => 'domain-broker-wmydanlm',
      'client_secret' => 'A1l0lGLHyZEKptF2FSlZfapJZtYFQflO'
  )
);

// -------------------------------------------------------------------
// Domains
// -------------------------------------------------------------------
// A list of the domains you want to use with domain broker.
// This list is also used for the domain portfolio feature if
// the 'enable_domain_portfolio' setting is set to true
//
// Format (repeat for each domain): 
//
// 'domain name here' => array(
//     'nicename' => 'ReplacesDomainNameText' // optional
//     'enable_purchase_type_field' => true, // optional
//     'price' => 'price here',
//     'lease_price' => 'price here', // optional
//     'description' => 'description here',
//     'not_for_sale' => false,
//     'image' => '' // background override
// ),
//
// Notes:
// * If you don't want a price or description, erase the contents
//   inside the quote marks
// * If the price is blank, the tag will not show
// * Enter domain names *without* the "http://" in front
$domains = array(
  'farmasi.fr' => [
		'nicename' => 'farmasi.fr',
		'price' => '1’500€',
		'lease_price' => '',
		'enable_purchase_type_field' => '',
		'description' => '',
		'not_for_sale' => false,
		'image' => ''
	], 
	'farmasi-fr.fr' => [
		'nicename' => 'farmasi-fr.fr',
		'price' => '1’500€',
		'lease_price' => '',
		'enable_purchase_type_field' => '',
		'description' => '',
		'not_for_sale' => false,
		'image' => ''
	], 
	'dietplus.ch' => [
		'nicename' => 'dietplus.ch',
		'price' => '1’500€',
		'lease_price' => '',
		'enable_purchase_type_field' => '',
		'description' => '',
		'not_for_sale' => false,
		'image' => ''
	], 
	'horosys.com' => [
		'nicename' => 'horosys.com',
		'price' => '1’000€',
		'lease_price' => '',
		'enable_purchase_type_field' => '',
		'description' => '',
		'not_for_sale' => false,
		'image' => ''
	], 
	'hudabeauty.ch' => [
		'nicename' => 'hudabeauty.ch',
		'price' => '1’500€',
		'lease_price' => '',
		'enable_purchase_type_field' => '',
		'description' => '',
		'not_for_sale' => false,
		'image' => ''
	], 
	'shophudabeauty.be' => [
		'nicename' => 'shophudabeauty.be',
		'price' => '1’500€',
		'lease_price' => '',
		'enable_purchase_type_field' => '',
		'description' => '',
		'not_for_sale' => false,
		'image' => ''
	], 
	'shophudabeauty.ch' => [
		'nicename' => 'shophudabeauty.ch',
		'price' => '1’500€',
		'lease_price' => '',
		'enable_purchase_type_field' => '',
		'description' => '',
		'not_for_sale' => false,
		'image' => ''
	], 
	'mas-tools.be' => [
		'nicename' => 'mas-tools.be',
		'price' => '1’500€',
		'lease_price' => '',
		'enable_purchase_type_field' => '',
		'description' => '',
		'not_for_sale' => false,
		'image' => ''
	], 
	'mas-tools.fr' => [
		'nicename' => 'mas-tools.fr',
		'price' => '1’500€',
		'lease_price' => '',
		'enable_purchase_type_field' => '',
		'description' => '',
		'not_for_sale' => false,
		'image' => ''
	], 
	
);