<?php

/**
 * Auth Index
 * Allows the user to choose an OAuth provider to log in with
 *
 * @package Domain Broker 2
 * @author Derek Loewen <derek@loewenweb.com>
 */ 

// Silence PHP notices
ini_set('display_errors', '0');

// Uncomment the folowing lines to show PHP errors/notices
//error_reporting(E_ALL);
//ini_set('display_errors', '1');

?>
<html>
<head>
	<title>Domain Broker 2 Editor</title>
	<!-- Load fonts -->
    <script type="text/javascript">
        WebFontConfig = {
            google: { 
                families: [ 'Open+Sans:300italic,800italic:latin', 'Open+Sans+Condensed:300:latin' ] 
            }
        };
        (function() {
        var wf = document.createElement('script');
        wf.src = ('https:' == document.location.protocol ? 'https' : 'http') +
        '://ajax.googleapis.com/ajax/libs/webfont/1.5.18/webfont.js';
        wf.type = 'text/javascript';
        wf.async = 'true';
        var s = document.getElementsByTagName('script')[0];
        s.parentNode.insertBefore(wf, s);
    })(); </script>
	<style>
		body {
			font: 24px/1.7 "Open Sans", sans-serif;
			font-weight: 300;
			text-align: center;
			color: #333;
			padding: 3em;
			/* Permalink - use to edit and share this gradient: http://colorzilla.com/gradient-editor/#e8e8e8+0,f4f4f4+100 */
			background: #e8e8e8; /* Old browsers */
			background: -moz-linear-gradient(top,  #e8e8e8 0%, #f4f4f4 100%); /* FF3.6+ */
			background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#e8e8e8), color-stop(100%,#f4f4f4)); /* Chrome,Safari4+ */
			background: -webkit-linear-gradient(top,  #e8e8e8 0%,#f4f4f4 100%); /* Chrome10+,Safari5.1+ */
			background: -o-linear-gradient(top,  #e8e8e8 0%,#f4f4f4 100%); /* Opera 11.10+ */
			background: -ms-linear-gradient(top,  #e8e8e8 0%,#f4f4f4 100%); /* IE10+ */
			background: linear-gradient(to bottom,  #e8e8e8 0%,#f4f4f4 100%); /* W3C */
		}
		a {
			color: #4E4E4E;
		}
		h1 {
			font-size: 48px;
			font-weight: 800;
		    font-style: italic;
		    color: #4E4E4E;
		    line-height: 1.8;
		}
		h1 span {
			color: #65738E;
		}
		ul {
			list-style: none;
			margin: 1.5em 0;
			padding: 0;
		}
		li {
			display: inline-block;
		}
		li a {
			text-decoration: none;
			display: block;
			font-size: 24px;
			background: white;
			border-radius: 5px;
			border: solid 1px #ccc;
			padding: 18px 26px;
			margin: 0 5px;
			box-shadow: 0 .1em .1em rgba(0,0,0, .1);
		}
		i {
			margin-right: 10px;
		}
		.icon-envato svg {
			display: inline-block;
			vertical-align: middle;
			width: 28px;
			height: auto;
		}
		small {
			color: #555;
			font-weight: 400;
			font-size: 14px;
			letter-spacing: .5px;
		}
	</style>

</head>
<body>
	<h1>Domain Broker 2 <span>Editor</span></h1>
	<p>Please log in with your Envato account by clicking the button below.</p>
	<ul>
		<li>
			<a href="./callback.php">
				<i class="icon-envato">
					<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 381.979 381.979" style="enable-background:new 0 0 381.979 381.979;" xml:space="preserve">
						<path style="fill:#90B24C;" d="M307.447,4.355c-13.981-7.505-46.504-5.208-84.733,6.098
						c-29.043,23.432-123.57,107.68-124.689,212.441c-0.09,8.466-11.647,10.833-14.991,3.054c-9.003-20.943-16.319-55.899-6.439-109.632
						c1.461-7.948-8.631-12.614-13.753-6.364c-3.441,4.199-6.705,8.512-9.77,12.937c-60.282,87.038-17.18,198.593,53.754,237.366
						c70.934,38.774,176.364,30.137,227.146-62.765C384.754,204.59,342.818,23.341,307.447,4.355z"/>
					</svg>
				</i>
				Log in with Envato
			</a>
		</li>
	</ul>
	<p><small><strong>Note:</strong> Make sure the Envato account you log in with uses the same email you entered<br> for the <code>editor_login_email</code> setting in config.php.</small></p>
</body>
</html>