<?php

/**
 * OAuth Callback
 * Authenticates with Envato, then stores the account's email address. Then redirects to the Visual Editor!
 *
 * @package Domain Broker 2
 * @author Derek Loewen <derek@loewenweb.com>
 */ 

// ----------------------------------------------------------------------------
// Error Reporting
// ----------------------------------------------------------------------------
// Un-comment the following lines to enable errors while testing

error_reporting(E_ALL);
ini_set('display_errors', '1');

// ----------------------------------------------------------------------------
// Begin Session
// ----------------------------------------------------------------------------

session_start();

// ----------------------------------------------------------------------------
// Includes
// ----------------------------------------------------------------------------

require_once '../config.php'; // Theme Configuration Settings
require_once '../includes/vendor/autoload.php'; // Autoload vendor packages
require_once '../includes/hybridauth-envato-adapter.php'; // Hybridauth Envato adapter

// ----------------------------------------------------------------------------
// Authenticate with Envato OAuth API
// ----------------------------------------------------------------------------

// Generate callback URL
$callback_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
$callback_url .= dirname($_SERVER['SCRIPT_NAME']) . "/callback.php";

// Build config array
$config = [
    'callback' =>  $callback_url,
    'keys' => [ 
        'id'     => $config['envato_oauth_keys']['client_id'],
        'secret' => $config['envato_oauth_keys']['client_secret']
    ]
];

// Use custom Envato adapter
$adapter = new Hybridauth\Provider\Envato($config);

// Perform authentication, store account email, redirect to editor
try {
    //$adapter->refreshAccessToken();
    if(isset($_SESSION['envato_access_token'])) {
        $adapter->setAccessToken($_SESSION['envato_access_token']);
    } else {
        $adapter->authenticate();
        $_SESSION['envato_access_token'] = $accessToken = $adapter->getAccessToken();
        $userProfile = $adapter->getUserProfile();
        $_SESSION['envato_account_email'] = $userProfile->email;
    }
    header("Location: ../?editor");
    exit;
}
catch( \Exception $e ){
    echo $e->getMessage();
}
