// --------------------------------------------------------------
// Resize reCAPTCHA to fit width of container
// --------------------------------------------------------------
// Since it has a fixed width, we have to scale it using CSS
// transform.
// Scaling factor: 300.54
// fieldWidth / captchaScale = 300.54
function scaleCaptcha() {
	var fieldWidth = $('.text-field').first().outerWidth();
	var captchaScale = fieldWidth / 300.54;
	$('.g-recaptcha').css({
		'transform':'scale('+captchaScale+')'
	});
}

// --------------------------------------------------------------
// Domain Portfolio
// --------------------------------------------------------------

var screenHeight;
var portfolio;
var domainList;
var domainListHeight;

function portfolioSetup() {
	// If the list of domains extends beyond the bottom of the screen,
	// Set it to scroll instead of clipping off at the bottom
	screenHeight = $(window).height();
	domainListHeight = $('#domains').outerHeight();

	if( (domainListHeight + 230) >= screenHeight ) {
		// Activate scrolling on domain list
		domainList.css({ height: (screenHeight - 230) + 'px', overflow: 'auto' });
	} else {
		domainList.css({ height: 'auto' });
	}
}

$(window).load(function() { 
	
	// Hide the list of domains initially
	$('#domains').hide();

	screenHeight = $(window).height();
	portfolio = $('#portfolio');
	domainList = $('#domains');
	domainListHeight = domainList.outerHeight();
	
	// When the window resizes, trigger domain portfolio re-positioning
	$(window).resize( $.throttle( 100, portfolioSetup ) );
	
	// Toggle Open/Close
	$('#more-domains-btn').on('click', function() { 
		$('#domains').slideToggle();
	});

	// Initial domain portfolio positioning
	portfolioSetup();

	// Re-run portfolioSetup in 1.5 seconds just in case the webfonts
	// aren't displaying yet
	window.setTimeout(function() { 
		portfolioSetup();
	}, 1500);

	// --------------------------------------------------------------
	// Domain Name
	// --------------------------------------------------------------

	// Fit domain dame text into the available width
	$('.header .title').bigtext({ maxfontsize: 160 });
});

$(function() { 

	// --------------------------------------------------------------
	// Live Refresh for Domain Information
	// --------------------------------------------------------------

	// A) Buy/Lease Toggle
	// --------------------------------------------------------------
	// When the buy/lease toggle field is switched, the 
	// corresponding price should display in the price tag

	// When the purchase_type field changes
	$('input[name="purchase_type"]').on('change', function() {
		var domain_info = [];
		var purchase_type = $(this).val();
		// Get the current domain name. The domain select field
		// might not be enabled, so we need to get it another way.
		var domain_name = DB2.current_domain;
		var input = { ajax: true, domain_name: domain_name };
		// Get the new domain info via AJAX
		$.get('includes/get-domain-info.php', input, function(data) {
			data = $.parseJSON(data);
			if( data['error'] != undefined ) {
				// Error!
				console.error(data['error']);
			} else {
				// Success, update template with new domain info!
				domain_info = data;
				var price = '';
				switch(purchase_type) {
					case 'lease':
						// set to lease price
						price = domain_info.lease_price;
						// change subtitle and price tag caption
						$('.header .subtitle').text(DB2.lease_prefix);
						$('.price-tag .caption').html(DB2.lease_price_tag_caption);
						break;
					default:
						// set to purchase price
						price = domain_info.price;
						// change subtitle and price tag caption
						$('.header .subtitle').text(DB2.buy_prefix);
						$('.price-tag .caption').html(DB2.price_tag_caption);
				}
				// Update price tag
				$('.header .price').text(price);
				// Show tag if it has a price, or hide it if there's no price
				if( price == '' ) {
					$('.header .price-tag').hide();
				} else {
					$('.header .price-tag').show();
				}
			}
		});
	});

	// B) Domain Selection Field 
	// --------------------------------------------------------------
	// When the domain selection field is enabled, changing the
	// selected domain will refresh the domain title, price,
	// description, and background image

	// Get default background image
	// Thanks to http://stackoverflow.com/a/23784236
	var default_bg_image = '';
	if( $(window).width() > 480 ) {
		// Wide Screen
		default_bg_image = $('body').css("background-image");
	} else {
		// Narrow Screen
		default_bg_image = $('.header').css("background-image");
	}
	default_bg_image = default_bg_image.replace(/.*\s?url\([\'\"]?/, '').replace(/[\'\"]?\).*/, '');

	// When the select field changes
	$('select[name="domain"]').on('change', function() {
		var domain_info = [];
		var domain_name = $(this).val();
		var input = { ajax: true, domain_name: domain_name };
		// Update global DB2 object with current domain name
		DB2.current_domain = domain_name;
		// Get the new domain info via AJAX
		$.get('includes/get-domain-info.php', input, function(data) {
			data = $.parseJSON(data);
			if( data['error'] != undefined ) {
				// Error!
				console.error(data['error']);
			} else {
				// Success, update template with new domain info!
				domain_info = data;
				var purchase_type = $('input[name="purchase_type"]:checked').val();
				// Hide or show the purchase type field
				if( 
					domain_info.enable_purchase_type_field === true 
					|| (
						domain_info.enable_purchase_type_field === ''
						&& DB2.enable_purchase_type_field === true
					)
				) {
					$('#purchase_type_field_wrapper').show();
				} else {
					$('#purchase_type_field_wrapper').hide();
				}
				// Hide or show the sale info
				if( domain_info.not_for_sale === true ) {
					// Not for sale? Hide price/"is for sale" text
					$('.header .price-tag').hide();
					$('.header .subtitle').hide();
				} else {
					// It is for sale! Make sure the price tag and 
					// "is for sale" text shows up
					if( 
						( purchase_type == 'buy' && domain_info.price != '' )
						|| ( purchase_type == 'lease' && domain_info.lease_price != '' )
					) {
						$('.header .price-tag').show();
					} else {
						$('.header .price-tag').hide();
					}
					if( purchase_type == 'lease' ) {
						$('.header .subtitle').show().text(DB2.lease_prefix);
					} else {
						$('.header .subtitle').show().text(DB2.buy_prefix);
					}
				}
				// Name
				$('.header .title span').text(domain_info.nicename);
				$('.header .title').bigtext();
				// Price (buy or lease price depending on purchase_type field)
				var price = '';
				switch(purchase_type) {
					case 'lease':
						price = domain_info.lease_price;
						break;
					default:
						price = domain_info.price;
				}
				$('.header .price').text(price);
				// Description
				$('.offer-form .description').html(domain_info.description);
				
				// Background
				// Use default image unless an override is specified
				var background_image_url = default_bg_image;
				if( domain_info.image != '' && domain_info.image != undefined ) {
					background_image_url = 'assets/images/bg-' + domain_info.image + '.jpg';
				}
				if( $(window).width() > 480 ) {
					// Wide Screen
					$('body').append($('<style>body { background-image: url(' + background_image_url + '); } </style>'));
				} else {
					// Narrow Screen
					$('body').append($('<style>@media (max-width: 480px) { .header { background-image: url(' + background_image_url + '); } } </style>'));
				}
			}
		});
	});

	// --------------------------------------------------------------
	// Offer Form
	// --------------------------------------------------------------

	// Placeholder support for older browsers (IE9 and below)
	$('input').placeholder();

	// Trigger captcha scaling 
	// first run on doc ready
	scaleCaptcha();
	// then on resize	
	$(window).resize( $.throttle( 100, scaleCaptcha ) );
	
	// AJAX Form Handling

	var offerForm = $("#offer-form");
	var successContainer = $('.form-success');
	var errorContainer = $('.form-error');
	$('.send-btn').removeAttr('disabled');

	// show a simple loading indicator
	var loader = jQuery('<div class="bubblingG"><span id="bubblingG_1"></span><span id="bubblingG_2"></span><span id="bubblingG_3"></span></div>')
		.appendTo('.send-btn-wrapper')
		.hide();

	// Validate form
	offerForm.validate({
		submitHandler: function(form) {
			var formData = offerForm.serialize();
			// Disable send button and show loading indicator
			$('.send-btn').attr('value', 'sending');
			$('.send-btn').attr('disabled', 'disabled');
			loader.show();
			$.post('index.php?ajax', formData, function(data) {
				data = $.parseJSON(data);
				if( data['success'] != '' ) {
					// Hide error message and form
					errorContainer.hide();
					$('.fields', offerForm).hide();
					// Display success message
					successContainer.show().append(data['success']);
				} else {
					// Display error message
					errorContainer.show().find('ul').empty().append(data['error']);
					// Reset captcha if it's enabled
					if( typeof grecaptcha !== 'undefined' ) {
						grecaptcha.reset();
					}
					// Change resubmit message if SMTP fails
					if( data['error_code'] == 'SMTP' ) {
						$('p', errorContainer).text('');
					}
				}
			}).always(function() { 
				// Re-enable send button and hide loading indicator
				$('.send-btn').attr('value', 'send');
				$('.send-btn').removeAttr('disabled');
				loader.hide();
			});
		}
	});

});